function [sub_array] = subset(array,sub_vert)
%This function will pull out a the subset of vertices desired from the full
%array generated by punc_distill
%Synatax:   [sub_array] = subset(array,sub_vert); 
%Input:     array = the original array.
%           sub_vert = :) The sub vertices we want pulled out.
%Output:     sub_array = the subset of of the original array.

sub_array = [];                 %initialize subarray
for i = 1:size(sub_vert,1)      %step through the verticies we want pulled out
    [idx,a] = find(array(:,3)==sub_vert(i,1)& array(:,4)==sub_vert(i,2) & array(:,5)==sub_vert(i,3));
    %put into the array, the pulled data
    sub_array = vertcat(sub_array,array(idx,:));
    idx = [];       %clear index
end
